<html>
<head>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://unpkg.com/tailwindcss@^2/dist/tailwind.min.css" rel="stylesheet">
</head>
<body>
<div id="app">
    <div class="leading-loose">
        <form class="max-w-xl m-4 p-10 bg-white rounded shadow-xl">
            <p class="text-gray-500 font-medium mb-3 font-bold">再配達の依頼</p>
            <div class="">
                <label class="block text-sm text-gray-00" for="cus_name">希望日</label>
                <input class="w-full px-5 py-1 text-gray-700 bg-gray-200 rounded" type="date" min="{{ date('Y-m-d') }}" v-model="params.date">
            </div>
            <div class="mt-3">
                <label class="block text-sm text-gray-600" for="cus_email">時間帯</label>
                <select class="w-full px-4  py-3 text-gray-700 bg-gray-200 rounded" v-model="params.time_id">
                    <option></option>
                    <option v-for="time in redeliveryTimes" :value="time.id" v-text="time.text"></option>
                </select>
            </div>
            <div class="mt-5">
                <button class="px-4 py-1 text-white font-light tracking-wider bg-blue-500 rounded" type="button" @click="onSubmit">送信する</button>
            </div>
        </form>
    </div>
</div>
<script src="/js/app.js"></script>
<script src="https://unpkg.com/vue@3.0.2/dist/vue.global.prod.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/axios/0.19.2/axios.min.js"></script>
<script>

    Vue.createApp({
        data() {
            return {
                params: {
                    date: '',
                    time_id: ''
                },
                redeliveryTimes: {!! config('redelivery.times') !!}
            }
        },
        methods: {
            onSubmit() {

                const url = '{{ route('redelivery.update', $redelivery->uuid) }}';
                axios.put(url, this.params)
                    .then(response => {

                        alert('再配達依頼が完了しました！');

                    })
                    .catch(error => {

                        alert('入力が正しくありません。');

                    });

            }
        }
    }).mount('#app');

</script>
</body>
</html>
